/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.repair.panel;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.pa.problem.Problem;
import com.ibm.hwmca.fw.pa.problem.history.HistoryEntry;
import com.ibm.hwmca.fw.service.serviceaction.ServiceAction;
import com.ibm.hwmca.fw.tasklet.SynchronousPanelTasklet;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.fru.CommonPaFru;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import com.ibm.hwmca.xfw.panel.repair.ProblemPanelBean;
import com.ibm.hwmca.xfw.repair.panel.CommonPanelFunctions;
import com.ibm.hwmca.xfw.repair.panel.SelectActionPanelHandler;
import com.ibm.hwmca.xfw.repair.panel.XFConstants;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ProblemPanelHandler {
    private static final String TRACE_MASKT = "XRVX043T";
    private static final String TRACE_MASKF = "XRVX043F";
    private static final String TRACE_MASKD = "XRVX043D";
    private SynchronousPanelTasklet displayHandle;

    public ProblemPanelHandler(SynchronousPanelTasklet displayHandle) {
        Trace.trace(TRACE_MASKT, "<> ProblemPanelHandler ctor");
        this.displayHandle = displayHandle;
    }

    public void display(Map userData) throws HException {
        CommonProblem commonProblem = (CommonProblem)userData.get("PROBLEM");
        ServiceAction repair = (ServiceAction)userData.get("REPAIR");
        boolean newProblem = false;
        boolean repairDelayedAtStart = repair.isDelayed();
        if (repairDelayedAtStart) {
            repair.setDelayed(false);
            commonProblem.serviceHistoryEvent(new HistoryEntry(8));
        } else {
            commonProblem.serviceHistoryEvent(new HistoryEntry(4));
        }
        boolean firstPass = true;
        boolean done = false;
        int path = 1;
        while (!done) {
            if (firstPass) {
                path = repairDelayedAtStart ? 2 : 1;
                firstPass = false;
            }
            if (path == 2) {
                new SelectActionPanelHandler(this.displayHandle).display(userData);
            } else {
                ProblemPanelBean bean = new ProblemPanelBean();
                bean.load();
                this.buildOutput(userData, bean);
                String problemType = commonProblem.getProblemType();
                String panelToDisplay = null;
                panelToDisplay = problemType != null && problemType.equals("1") ? "HMCProblemPanel" : "RecordFruPanel";
                bean = (ProblemPanelBean)this.displayHandle.replace(XFConstants.RES_FILE_NAME, panelToDisplay, bean);
                String event = bean.getActionCommand().toUpperCase();
                userData.put("LAST_PANEL_ACTION", event);
                if (event.equals("ViewServicePanelsButton".toUpperCase())) {
                    while (event.equals("ViewServicePanelsButton".toUpperCase())) {
                        bean = (ProblemPanelBean)CommonPanelFunctions.launchProblemAnalysis(bean, userData);
                        event = bean.getActionCommand().toUpperCase();
                    }
                }
                if (event.equals("DELAYREPAIRBUTTON")) {
                    repair.setDelayed(true);
                    commonProblem.serviceHistoryEvent(new HistoryEntry(5));
                    done = true;
                } else if (event.equals("OKBUTTON")) {
                    new SelectActionPanelHandler(this.displayHandle).display(userData);
                    if (!((String)userData.get("LAST_PANEL_ACTION")).equals("OKBUTTON")) continue;
                }
            }
            if (userData.get("PROBLEM_NOT_FIXED") != null) {
                userData.remove("PROBLEM_NOT_FIXED");
                path = 1;
                continue;
            }
            done = true;
            if (!repairDelayedAtStart || ((String)userData.get("LAST_PANEL_ACTION")).equals("OKBUTTON")) continue;
            repair.setDelayed(true);
            commonProblem.serviceHistoryEvent(new HistoryEntry(5));
        }
        Trace.trace(TRACE_MASKT, "<- ProblemPanelHandler.display");
    }

    private void buildOutput(Map userData, ProblemPanelBean bean) throws HException {
        Problem p = (Problem)userData.get("PROBLEM");
        if (!(p instanceof CommonProblem)) {
            throw new HException("ProblemPanelHandler requires selected problem to be a CommonProblem; found: " + p);
        }
        List paFruList = ((CommonProblem)p).getParts();
        LinkedList<LocalizableText> doclist = new LinkedList<LocalizableText>();
        LocalizableText br = new LocalizableText("<br>");
        doclist.addLast(new LocalizableText("<HTML>"));
        doclist.addLast(new LocalizableText("com.ibm.hwmca.base.res.text", "perfcons.binder"));
        doclist.addLast(br);
        doclist.addLast(new LocalizableText("com.ibm.hwmca.base.res.text", "perfcons.manual"));
        doclist.addLast(br);
        doclist.addLast(new LocalizableText("com.ibm.hwmca.base.res.text", "perfcons.chapter"));
        doclist.addLast(new LocalizableText("</HTML>"));
        bean.setDocumentationOutput(doclist);
        if (paFruList != null && paFruList.size() > 0) {
            Iterator pafrus = paFruList.iterator();
            bean.clearFruTable();
            int row = 0;
            while (pafrus.hasNext()) {
                CommonPaFru pafru = (CommonPaFru)pafrus.next();
                Serializable[] singleRow = new Serializable[]{pafru.getLocation(), pafru.getPartNumber()};
                bean.setFruTableRowAt(row, singleRow);
                ++row;
            }
        }
    }
}

